(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     88950,       2159]
NotebookOptionsPosition[     86001,       2103]
NotebookOutlinePosition[     86396,       2119]
CellTagsIndexPosition[     86353,       2116]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"F", "[", 
   RowBox[{"x_", ",", " ", "y_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"r", "^", 
    RowBox[{"(", 
     RowBox[{"-", "2"}], ")"}]}], " ", 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ")"}]}], "/", 
     RowBox[{"r", "^", "2"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"aedf0dac-bf10-4a2d-90f5-6cf8f19207c0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dx", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "0", ",", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"F", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "}"}]}]], "Input",\

 CellLabel->"In[2]:=",ExpressionUUID->"d815061c-1a03-45ac-ba1d-325599419cd1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["x", "2"]}], "-", 
         SuperscriptBox["y", "2"]}], 
        SuperscriptBox["r", "2"]]], " ", "x"}], 
     SuperscriptBox["r", "4"]]}]}], "}"}]], "Output",
 CellChangeTimes->{3.796877270823701*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"fa5f56bc-f2e0-4178-9d73-d4b529c8c3f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dy", "=", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"F", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}], "}"}]}]], "Input",\

 CellLabel->"In[3]:=",ExpressionUUID->"8581354c-cfbc-40e9-a80b-c385f77db855"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["x", "2"]}], "-", 
         SuperscriptBox["y", "2"]}], 
        SuperscriptBox["r", "2"]]], " ", "y"}], 
     SuperscriptBox["r", "4"]]}]}], "}"}]], "Output",
 CellChangeTimes->{3.7968772708412437`*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"edd96b72-ccf4-4120-8a59-d8a7d77a1691"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"gxx", "=", 
  RowBox[{"dx", ".", "dx"}]}], "\[IndentingNewLine]", 
 RowBox[{"gxy", "=", 
  RowBox[{"dx", ".", "dy"}]}], "\[IndentingNewLine]", 
 RowBox[{"gyy", "=", 
  RowBox[{"dy", ".", "dy"}]}]}], "Input",
 CellChangeTimes->{{3.796877090209*^9, 3.796877095894972*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"44706242-52dc-49b6-9d9d-3fc859304f6a"],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["\[ExponentialE]", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["x", "2"]}], "-", 
         SuperscriptBox["y", "2"]}], ")"}]}], 
      SuperscriptBox["r", "2"]]], " ", 
    SuperscriptBox["x", "2"]}], 
   SuperscriptBox["r", "8"]]}]], "Output",
 CellChangeTimes->{3.796877270897614*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"4aa5729e-da04-4e40-9cda-ace83220c6df"],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["x", "2"]}], "-", 
        SuperscriptBox["y", "2"]}], ")"}]}], 
     SuperscriptBox["r", "2"]]], " ", "x", " ", "y"}], 
  SuperscriptBox["r", "8"]]], "Output",
 CellChangeTimes->{3.796877270904161*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"1db6028c-b0e6-4548-b1c0-b04e47358ea6"],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["\[ExponentialE]", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["x", "2"]}], "-", 
         SuperscriptBox["y", "2"]}], ")"}]}], 
      SuperscriptBox["r", "2"]]], " ", 
    SuperscriptBox["y", "2"]}], 
   SuperscriptBox["r", "8"]]}]], "Output",
 CellChangeTimes->{3.796877270908149*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"0814b7dd-bac5-4521-8d4b-aa6ade94f817"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"g", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"gxx", ",", "gxy"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"gxy", ",", "gyy"}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"ginv", "=", 
  RowBox[{
   RowBox[{"Inverse", "[", "g", "]"}], "//", "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.796877110102654*^9, 3.796877110404737*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"96717c7e-2234-46a6-9e4d-c66a62680b2d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["x", "2"]}], "-", 
             SuperscriptBox["y", "2"]}], ")"}]}], 
          SuperscriptBox["r", "2"]]], " ", 
        SuperscriptBox["x", "2"]}], 
       SuperscriptBox["r", "8"]]}], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["x", "2"]}], "-", 
            SuperscriptBox["y", "2"]}], ")"}]}], 
         SuperscriptBox["r", "2"]]], " ", "x", " ", "y"}], 
      SuperscriptBox["r", "8"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["x", "2"]}], "-", 
            SuperscriptBox["y", "2"]}], ")"}]}], 
         SuperscriptBox["r", "2"]]], " ", "x", " ", "y"}], 
      SuperscriptBox["r", "8"]], ",", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["x", "2"]}], "-", 
             SuperscriptBox["y", "2"]}], ")"}]}], 
          SuperscriptBox["r", "2"]]], " ", 
        SuperscriptBox["y", "2"]}], 
       SuperscriptBox["r", "8"]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.796877270921156*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"515c19b6-b97c-4a2f-a3a2-8295bd0a95f0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}], ")"}]}], 
          SuperscriptBox["r", "2"]]], " ", 
        SuperscriptBox["r", "8"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["y", "2"]}]}], 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}], ")"}]}], 
          SuperscriptBox["r", "2"]]], " ", 
        SuperscriptBox["r", "8"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}]}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", "x", " ", "y"}], 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["x", "2"], "+", 
              SuperscriptBox["y", "2"]}], ")"}]}], 
           SuperscriptBox["r", "2"]]], " ", 
         SuperscriptBox["r", "8"]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], ")"}]}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", "x", " ", "y"}], 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["x", "2"], "+", 
              SuperscriptBox["y", "2"]}], ")"}]}], 
           SuperscriptBox["r", "2"]]], " ", 
         SuperscriptBox["r", "8"]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], ")"}]}]}]]}], ",", 
     FractionBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}], ")"}]}], 
          SuperscriptBox["r", "2"]]], " ", 
        SuperscriptBox["r", "8"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}], ")"}]}], 
          SuperscriptBox["r", "2"]]], " ", 
        SuperscriptBox["r", "8"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}]}]}]]}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{3.7968772710058317`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"4e06ab3f-efc1-4823-ae2d-0bf33e80d7ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"X", "=", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"bec40bbd-c0d3-4da5-a1e5-58a4f7def6d5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y"}], "}"}]], "Output",
 CellChangeTimes->{3.796877271019269*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"d2e6eed4-235d-4897-b8d8-69a358723c5d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"dg", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"g", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], ",", 
      RowBox[{"X", "[", 
       RowBox[{"[", "k", "]"}], "]"}]}], " ", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "2"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Gam", "[", 
   RowBox[{"i_", ",", "j_", ",", "k_"}], "]"}], ":=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "/", "2"}], ")"}], 
     RowBox[{"ginv", "[", 
      RowBox[{"[", 
       RowBox[{"k", ",", "l"}], "]"}], "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"dg", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "l"}], "]"}], "]"}]}], "+", 
       RowBox[{"dg", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "l", ",", "j"}], "]"}], "]"}], "+", 
       RowBox[{"dg", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "l", ",", "i"}], "]"}], "]"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"l", ",", "1", ",", "2"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ga", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Gam", "[", 
      RowBox[{"i", ",", "j", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Gat", "=", 
  RowBox[{
   RowBox[{"Ga", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"u", "[", "t", "]"}]}], ",", " ", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"v", "[", "t", "]"}]}]}], "}"}]}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.796877147556059*^9, 3.796877163726087*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"ac529ce2-424a-42de-9319-7a520e3d2719"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["x", "2"]}], "-", 
               SuperscriptBox["y", "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", "x"}], 
         SuperscriptBox["r", "8"]], "-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["x", "2"]}], "-", 
               SuperscriptBox["y", "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", 
          SuperscriptBox["x", "3"]}], 
         SuperscriptBox["r", "10"]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["x", "2"]}], "-", 
               SuperscriptBox["y", "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", 
          SuperscriptBox["x", "2"], " ", "y"}], 
         SuperscriptBox["r", "10"]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["x", "2"]}], "-", 
               SuperscriptBox["y", "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", "y"}], 
         SuperscriptBox["r", "8"]], "-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["x", "2"]}], "-", 
               SuperscriptBox["y", "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", 
          SuperscriptBox["x", "2"], " ", "y"}], 
         SuperscriptBox["r", "10"]]}], ",", 
       RowBox[{
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["x", "2"]}], "-", 
               SuperscriptBox["y", "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", "x"}], 
         SuperscriptBox["r", "8"]], "-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["x", "2"]}], "-", 
               SuperscriptBox["y", "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", "x", " ", 
          SuperscriptBox["y", "2"]}], 
         SuperscriptBox["r", "10"]]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["x", "2"]}], "-", 
               SuperscriptBox["y", "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", "y"}], 
         SuperscriptBox["r", "8"]], "-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["x", "2"]}], "-", 
               SuperscriptBox["y", "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", 
          SuperscriptBox["x", "2"], " ", "y"}], 
         SuperscriptBox["r", "10"]]}], ",", 
       RowBox[{
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["x", "2"]}], "-", 
               SuperscriptBox["y", "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", "x"}], 
         SuperscriptBox["r", "8"]], "-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["x", "2"]}], "-", 
               SuperscriptBox["y", "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", "x", " ", 
          SuperscriptBox["y", "2"]}], 
         SuperscriptBox["r", "10"]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["x", "2"]}], "-", 
               SuperscriptBox["y", "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", "x", " ", 
          SuperscriptBox["y", "2"]}], 
         SuperscriptBox["r", "10"]]}], ",", 
       RowBox[{
        FractionBox[
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["x", "2"]}], "-", 
               SuperscriptBox["y", "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", "y"}], 
         SuperscriptBox["r", "8"]], "-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["x", "2"]}], "-", 
               SuperscriptBox["y", "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", 
          SuperscriptBox["y", "3"]}], 
         SuperscriptBox["r", "10"]]}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.7968772710941763`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"c06f9972-8a19-4680-94d1-263c92b985f7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"4", " ", 
         RowBox[{"u", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["r", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"u", "[", "t", "]"}], "2"]}]}], ")"}]}], 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             FractionBox[
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"u", "[", "t", "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"v", "[", "t", "]"}], "2"]}], ")"}]}], 
              SuperscriptBox["r", "2"]]], " ", 
            SuperscriptBox["r", "8"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"u", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"v", "[", "t", "]"}], "2"]}]}], ")"}]}]], ",", 
       FractionBox[
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["r", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"u", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         RowBox[{"v", "[", "t", "]"}]}], 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             FractionBox[
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"u", "[", "t", "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"v", "[", "t", "]"}], "2"]}], ")"}]}], 
              SuperscriptBox["r", "2"]]], " ", 
            SuperscriptBox["r", "8"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"u", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"v", "[", "t", "]"}], "2"]}]}], ")"}]}]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"8", " ", 
          SuperscriptBox[
           RowBox[{"u", "[", "t", "]"}], "2"], " ", 
          RowBox[{"v", "[", "t", "]"}]}], 
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              FractionBox[
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"u", "[", "t", "]"}], "2"], "+", 
                  SuperscriptBox[
                   RowBox[{"v", "[", "t", "]"}], "2"]}], ")"}]}], 
               SuperscriptBox["r", "2"]]], " ", 
             SuperscriptBox["r", "8"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"u", "[", "t", "]"}], "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"v", "[", "t", "]"}], "2"]}]}], ")"}]}]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"8", " ", 
          RowBox[{"u", "[", "t", "]"}], " ", 
          SuperscriptBox[
           RowBox[{"v", "[", "t", "]"}], "2"]}], 
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              FractionBox[
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"u", "[", "t", "]"}], "2"], "+", 
                  SuperscriptBox[
                   RowBox[{"v", "[", "t", "]"}], "2"]}], ")"}]}], 
               SuperscriptBox["r", "2"]]], " ", 
             SuperscriptBox["r", "8"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"u", "[", "t", "]"}], "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"v", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"8", " ", 
          SuperscriptBox[
           RowBox[{"u", "[", "t", "]"}], "2"], " ", 
          RowBox[{"v", "[", "t", "]"}]}], 
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              FractionBox[
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"u", "[", "t", "]"}], "2"], "+", 
                  SuperscriptBox[
                   RowBox[{"v", "[", "t", "]"}], "2"]}], ")"}]}], 
               SuperscriptBox["r", "2"]]], " ", 
             SuperscriptBox["r", "8"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"u", "[", "t", "]"}], "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"v", "[", "t", "]"}], "2"]}]}], ")"}]}]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"8", " ", 
          RowBox[{"u", "[", "t", "]"}], " ", 
          SuperscriptBox[
           RowBox[{"v", "[", "t", "]"}], "2"]}], 
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              FractionBox[
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"u", "[", "t", "]"}], "2"], "+", 
                  SuperscriptBox[
                   RowBox[{"v", "[", "t", "]"}], "2"]}], ")"}]}], 
               SuperscriptBox["r", "2"]]], " ", 
             SuperscriptBox["r", "8"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"u", "[", "t", "]"}], "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"v", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"4", " ", 
         RowBox[{"u", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["r", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"v", "[", "t", "]"}], "2"]}]}], ")"}]}], 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             FractionBox[
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"u", "[", "t", "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"v", "[", "t", "]"}], "2"]}], ")"}]}], 
              SuperscriptBox["r", "2"]]], " ", 
            SuperscriptBox["r", "8"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"u", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"v", "[", "t", "]"}], "2"]}]}], ")"}]}]], ",", 
       FractionBox[
        RowBox[{"4", " ", 
         RowBox[{"v", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["r", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"v", "[", "t", "]"}], "2"]}]}], ")"}]}], 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             FractionBox[
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"u", "[", "t", "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"v", "[", "t", "]"}], "2"]}], ")"}]}], 
              SuperscriptBox["r", "2"]]], " ", 
            SuperscriptBox["r", "8"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"u", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"v", "[", "t", "]"}], "2"]}]}], ")"}]}]]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.796877271205646*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"9d6c00d7-8052-407e-9b53-aded4f3c0d7d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Equv", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"u", "''"}], "[", "t", "]"}], " ", "+", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"u", "'"}], "[", "t", "]"}], ",", 
           RowBox[{
            RowBox[{"v", "'"}], "[", "t", "]"}]}], "}"}], ".", 
         RowBox[{"Gat", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "All", ",", "1"}], "]"}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"u", "'"}], "[", "t", "]"}], ",", 
           RowBox[{
            RowBox[{"v", "'"}], "[", "t", "]"}]}], "}"}]}], "//", 
        "Simplify"}], "]"}]}], "\[Equal]", "0"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"v", "''"}], "[", "t", "]"}], " ", "+", 
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"u", "'"}], "[", "t", "]"}], ",", 
           RowBox[{
            RowBox[{"v", "'"}], "[", "t", "]"}]}], "}"}], ".", 
         RowBox[{"Gat", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "All", ",", "2"}], "]"}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"u", "'"}], "[", "t", "]"}], ",", 
           RowBox[{
            RowBox[{"v", "'"}], "[", "t", "]"}]}], "}"}]}], "//", 
        "Simplify"}], "]"}]}], "\[Equal]", "0"}], " ", ",", " ", 
    RowBox[{
     RowBox[{"u", "[", "0", "]"}], "\[Equal]", 
     RowBox[{"-", "1"}]}], ",", 
    RowBox[{
     RowBox[{"v", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"u", "'"}], "[", "0", "]"}], "==", 
     RowBox[{"Cos", "[", "phi", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"v", "'"}], "[", "0", "]"}], "\[Equal]", 
     RowBox[{"Sin", "[", "phi", "]"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{3.796877185951922*^9},
 CellLabel->"In[14]:=",ExpressionUUID->"4c3f8c37-603a-4018-ac1b-10132a59863d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"u", "[", "t", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["r", "2"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"u", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["u", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], "2"]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"u", "[", "t", "]"}], " ", 
          RowBox[{"v", "[", "t", "]"}], " ", 
          RowBox[{
           SuperscriptBox["u", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], " ", 
          RowBox[{
           SuperscriptBox["v", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["r", "2"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"v", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["v", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], "2"]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"u", "[", "t", "]"}], "2"], "+", 
               SuperscriptBox[
                RowBox[{"v", "[", "t", "]"}], "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", 
          SuperscriptBox["r", "8"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"u", "[", "t", "]"}], "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"v", "[", "t", "]"}], "2"]}]}], ")"}]}]], "+", 
     RowBox[{
      SuperscriptBox["u", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"v", "[", "t", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["r", "2"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"u", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["u", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], "2"]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"u", "[", "t", "]"}], " ", 
          RowBox[{"v", "[", "t", "]"}], " ", 
          RowBox[{
           SuperscriptBox["u", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], " ", 
          RowBox[{
           SuperscriptBox["v", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["r", "2"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"v", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["v", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], "2"]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"u", "[", "t", "]"}], "2"], "+", 
               SuperscriptBox[
                RowBox[{"v", "[", "t", "]"}], "2"]}], ")"}]}], 
            SuperscriptBox["r", "2"]]], " ", 
          SuperscriptBox["r", "8"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"u", "[", "t", "]"}], "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"v", "[", "t", "]"}], "2"]}]}], ")"}]}]], "+", 
     RowBox[{
      SuperscriptBox["v", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{"u", "[", "0", "]"}], "\[Equal]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    RowBox[{"v", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["u", "\[Prime]",
      MultilineFunction->None], "[", "0", "]"}], "\[Equal]", 
    RowBox[{"Cos", "[", "phi", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["v", "\[Prime]",
      MultilineFunction->None], "[", "0", "]"}], "\[Equal]", 
    RowBox[{"Sin", "[", "phi", "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.796877271309725*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"14403f97-4b02-4341-82ae-d1531f0e4e19"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"s", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Equv", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"r", "\[Rule]", "1"}], ",", 
        RowBox[{"phi", "\[Rule]", "0.2"}]}], "}"}]}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"u", ",", "v"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "[", "t", "]"}], ",", 
       RowBox[{"v", "[", "t", "]"}]}], "}"}], "/.", "s"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7968771977158623`*^9, 3.796877198113512*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"cd8b0d42-90a3-4b24-8992-85ae886747d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", "\[Rule]", 
     InterpretationBox[
      RowBox[{
       TagBox["InterpolatingFunction",
        "SummaryHead"], "[", 
       DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = 
        "Ready"}, 
        TemplateBox[{
          PaneSelectorBox[{False -> GridBox[{{
                PaneBox[
                 ButtonBox[
                  DynamicBox[
                   FEPrivate`FrontEndResource[
                   "FEBitmaps", "SquarePlusIconMedium"]], 
                  ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], 
                 Alignment -> {Center, Center}, ImageSize -> 
                 Dynamic[{
                   Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                GraphicsBox[{{{{}, {}, 
                    TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAotpLlPIyYj7V6ynu///vv8YpATtp
saA/O5PkJJr77r91Da0CI2WxP6uTKvQt5O2/apta4A/YuT90pZP+quHsv96v
D5ZHEME/aE0GfSnm678vzpNoZI7FP/AByWcj1+q/MndYd8C/yT+8XG12h9vp
v13cvrL5Ss4/btfAeODL6L9bbpgSfmDRP3sK6qvDwee/4bPx6R510z8smdWa
pMnmv3vXm1euttU/jQHOizu85b9uQGZj3dHXP1x5nrHuv+S/+Ha2CnHi2T9f
6kIGacfjv5eLV0jzH9w/BeRcy+q34r+O5RgkFTfeP7Kd6XxauOG/zY4Vy5I9
4D9/FCKPTKDgv56R4VFNWuE/+GGzGFoT378ct72n12PiP8aWyH3uA92/pEvC
SNmD4z80Q9q9Mr7av9gC17iqkOQ/y3b5jfiU2L8WKRR087PlP2/yvbUXMda/
IDYUfe7R5j/r112GqcrTv9dlJFW53Oc/fxzOYmqA0b+YBF14+/3oP2RnNywW
7M2/Bcalag0M6j+wfuoV1hHJvz5usarRFOs/cfFkQP02xL+BheU1DTTsP4FV
OkXwsr2/cL8pkBhA7T89wJepfIizv2loljWbYu4/o2JlixDNoL8u+MUo0H/v
P84jF9xbqIQ/T9WCdepE8D9EbRX5HqCpPwzmNnwo1fA/wXBRde7Ttz8fCHNq
zlvxPy8lc2PX/cA/mJ2Qf83f8T818V+i4uPFP5ZqQjoIb/I/dNROKC0ayz/q
SHzcqvTyP4fzFao83M8/xF5KJImF8z9G8gkMWHPSP/SFoFPPDPQ/haBUIPy/
1D+KINipbpH0PzRj8sOw9NY/pfKjpUkh9T/PT0M9S0zZPxbW94iMp/U/cytX
Yc9w2z8M8d8RCzn2PwBGerFjuN0/aH+pweLH9j/CFZZ0sevfPxof+1giTfc/
hIKSntz44D9R9uCVnd33P5wOQ3hHDuI/3t5OuoBk+D/F9RZvmw7jP9E6ngW9
6Pg/PrzRVuUH5D9JzoH2NHj5PwpdGzWoFOU/F3PtzhT++T+W6ma2Uw7mP2pP
7Uwwj/o/xknBfD4c5z8jn87xpB37P+Zz/7UEJeg/MgA4foGi+z9lnUIuMxzp
P8aYNbCZMvw/qLiKcvwo6j+xQrvJGbn8P6x6YKjuJOs/ISTViNVK/T8bShd3
fjfsP/Z40G7q2f0/K7TaFw9H7T8i31M8Z1/+P8/LkjyLRu4/03xrrx/w/j+6
2hJlM17vP9orCwpAd/8/OnLXYxAz8D+2hub2////P2F/4zshuvA/6wcEUg==

                    "]]}, 
                    Annotation[#, "Charting`Private`Tag$2958#1"]& ]}}, {}}, {
                 DisplayFunction -> Identity, Ticks -> {Automatic, Automatic},
                   AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                  GridLines -> {None, None}, DisplayFunction -> Identity, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                  All, DisplayFunction -> Identity, AspectRatio -> 1, 
                  Axes -> {False, False}, AxesLabel -> {None, None}, 
                  AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                  Frame -> {{True, True}, {True, True}}, 
                  FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                  Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                  FrameTicks -> {{None, None}, {None, None}}, 
                  GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                  Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                  Method -> {
                   "DefaultBoundaryStyle" -> Automatic, 
                    "DefaultGraphicsInteraction" -> {
                    "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None, 
                    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                  PlotRange -> {{0., 2.}, {-0.9999999667774043, 
                   1.0454418506050944`}}, PlotRangeClipping -> True, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                GridBox[{{
                   RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {
                  "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                 BaseStyle -> {
                  ShowStringCharacters -> False, NumberMarks -> False, 
                   PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
              GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              BaselinePosition -> {1, 1}], True -> GridBox[{{
                PaneBox[
                 ButtonBox[
                  DynamicBox[
                   FEPrivate`FrontEndResource[
                   "FEBitmaps", "SquareMinusIconMedium"]], 
                  ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], 
                 Alignment -> {Center, Center}, ImageSize -> 
                 Dynamic[{
                   Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                GraphicsBox[{{{{}, {}, 
                    TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAotpLlPIyYj7V6ynu///vv8YpATtp
saA/O5PkJJr77r91Da0CI2WxP6uTKvQt5O2/apta4A/YuT90pZP+quHsv96v
D5ZHEME/aE0GfSnm678vzpNoZI7FP/AByWcj1+q/MndYd8C/yT+8XG12h9vp
v13cvrL5Ss4/btfAeODL6L9bbpgSfmDRP3sK6qvDwee/4bPx6R510z8smdWa
pMnmv3vXm1euttU/jQHOizu85b9uQGZj3dHXP1x5nrHuv+S/+Ha2CnHi2T9f
6kIGacfjv5eLV0jzH9w/BeRcy+q34r+O5RgkFTfeP7Kd6XxauOG/zY4Vy5I9
4D9/FCKPTKDgv56R4VFNWuE/+GGzGFoT378ct72n12PiP8aWyH3uA92/pEvC
SNmD4z80Q9q9Mr7av9gC17iqkOQ/y3b5jfiU2L8WKRR087PlP2/yvbUXMda/
IDYUfe7R5j/r112GqcrTv9dlJFW53Oc/fxzOYmqA0b+YBF14+/3oP2RnNywW
7M2/Bcalag0M6j+wfuoV1hHJvz5usarRFOs/cfFkQP02xL+BheU1DTTsP4FV
OkXwsr2/cL8pkBhA7T89wJepfIizv2loljWbYu4/o2JlixDNoL8u+MUo0H/v
P84jF9xbqIQ/T9WCdepE8D9EbRX5HqCpPwzmNnwo1fA/wXBRde7Ttz8fCHNq
zlvxPy8lc2PX/cA/mJ2Qf83f8T818V+i4uPFP5ZqQjoIb/I/dNROKC0ayz/q
SHzcqvTyP4fzFao83M8/xF5KJImF8z9G8gkMWHPSP/SFoFPPDPQ/haBUIPy/
1D+KINipbpH0PzRj8sOw9NY/pfKjpUkh9T/PT0M9S0zZPxbW94iMp/U/cytX
Yc9w2z8M8d8RCzn2PwBGerFjuN0/aH+pweLH9j/CFZZ0sevfPxof+1giTfc/
hIKSntz44D9R9uCVnd33P5wOQ3hHDuI/3t5OuoBk+D/F9RZvmw7jP9E6ngW9
6Pg/PrzRVuUH5D9JzoH2NHj5PwpdGzWoFOU/F3PtzhT++T+W6ma2Uw7mP2pP
7Uwwj/o/xknBfD4c5z8jn87xpB37P+Zz/7UEJeg/MgA4foGi+z9lnUIuMxzp
P8aYNbCZMvw/qLiKcvwo6j+xQrvJGbn8P6x6YKjuJOs/ISTViNVK/T8bShd3
fjfsP/Z40G7q2f0/K7TaFw9H7T8i31M8Z1/+P8/LkjyLRu4/03xrrx/w/j+6
2hJlM17vP9orCwpAd/8/OnLXYxAz8D+2hub2////P2F/4zshuvA/6wcEUg==

                    "]]}, 
                    Annotation[#, "Charting`Private`Tag$2958#1"]& ]}}, {}}, {
                 DisplayFunction -> Identity, Ticks -> {Automatic, Automatic},
                   AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                  GridLines -> {None, None}, DisplayFunction -> Identity, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                  All, DisplayFunction -> Identity, AspectRatio -> 1, 
                  Axes -> {False, False}, AxesLabel -> {None, None}, 
                  AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                  Frame -> {{True, True}, {True, True}}, 
                  FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                  Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                  FrameTicks -> {{None, None}, {None, None}}, 
                  GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                  Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                  Method -> {
                   "DefaultBoundaryStyle" -> Automatic, 
                    "DefaultGraphicsInteraction" -> {
                    "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None, 
                    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                  PlotRange -> {{0., 2.}, {-0.9999999667774043, 
                   1.0454418506050944`}}, PlotRangeClipping -> True, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                GridBox[{{
                   RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {
                  "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                 BaseStyle -> {
                  ShowStringCharacters -> False, NumberMarks -> False, 
                   PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
              GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              BaselinePosition -> {1, 1}]}, 
           Dynamic[Typeset`open$$], ImageSize -> Automatic]},
         "SummaryPanel"],
        DynamicModuleValues:>{}], "]"}],
      InterpolatingFunction[{{0., 2.}}, {
       5, 7, 2, {96}, {4}, 0, 0, 0, 0, Automatic, {}, {}, 
        False}, CompressedData["
1:eJxFkosv1AEAxw85dJlJTi2UIb1o5LVVvimuNUvS1EWmkvTyuE5SLrnWyu1G
rYhbqp1XlHQVdSqFsF7yOJFCnqfOvbjzO+cOtdXWZ/vs8w98HA4lhMYYkkgk
gz8eIP3Hz9xQvYLrgr/1AbvFSni1gQGbN8x0b1M24m/2Ojm7ccDKjZgmUXgg
PhrXcyv4cPvUS87tKkHsp6qgAlI5QsS0d53ZAmSI7c0Ha6pQKyZ2ycQvwGLG
BulNapHHFMnY+fWoZOKaiXsjAqq0bbcvv0cH8dTKs6cZHrbPV48sboN2Y3aQ
YKsIdZGMk6nxX8BJC86k8boQcndNhWVDNxbXmrb0yL+jv39EcW9JH0rFD3bn
DPyALyGMqOvox1LtLXOhcABzurQ3FfmDGJo9yChOH8LrM+dPffUeBk+Zx6TI
hsE8VpnkVziC4MGW04x9YqyKGEsushjFvA5ySlfjKJa/jCrxpf/EhgJhB0/y
E3s5lkY61i8wE4+777eQIGvv26gavgT3/Wyz7D3H0Oh8+tWFpjH8yI1sMvaT
QmtGa+VWSbGQ5fbN0lWGtXLqcG6RDIEH5mR2tnJEtY9qCm/IcTag1WA1RYHr
z4QUwUUFylfyrb2nFYhubrDo81UikVy9iJ+kBAsPlxwWKMFJ4du7SJW4+TjH
UeIyjkIJZ+XD6HEIHNNcE++O49X+Ux7rv4/jfc4RH4I6gc7P4RurQycwZLLT
n5U1AeXmrTR8mID+rE+QIVkFs6drQhr9VaBKl4VlnFehL4pdfqZOhWLRoFGs
sRpx2wIi9mxXw/Nl8ZPATDX0bibzvdrUeFtw9KCT9SS41A9Cq32TqIxs3R4o
nERvUee3ZBsCZGnPidJkAuvWD+m7vxCgn/uVSfHSgF2nsN+UrUGZKfEoXqVB
qs64nXF8Cjvk1uqkgSksG3CmptC1UIq8fFNbtKhvCgxPo00juzqMxa6ZRkx5
zJ1LnjpceS4i2lt1KKv33+kQp8fH5kf3EsxmIPtqR3pdPAOLYS59wZZZuCu0
gvC+WfA0LLprwhz+bb/5N3Wzh2Y=
       "], {
       Developer`PackedArrayForm, CompressedData["
1:eJwl0I1GgwEAQNGvUpZSmqUspRERESNGjDFGjM0YEf0QkUZERERExBgRERER
ERERERERERERERExYkQdupwXuLGZUn6xLgiC6eC/BppoppV2wnTSTQ99xBhg
kCGGGSHOKAnGSJIiTYZxsuQoUGSCSaaYZY55FiixxDIrrLLGOhtsssU2ZSrs
sMse+xxwyBHHnHDKGedccMkV19xwyx33PPDIE8+88Mob73zwyRdVvqnxwy/1
BjcSooU2OojQRZRe+vkDD8gtsA==
        "], CompressedData["
1:eJwd1Xkg1AkfBnCkk5QiSypKSYzaqXXXN3K0NkcqrI1KRa4lr8wmiyEt2bba
lGWpaJHFmskQg76k2EzkGHcjzAzjmN9cEeV4ve/zx/PH89fz30fXN9Ttoryc
nJzO/+r/EWOUL+U+47QIDs/TX6gw2BhlFtr524IInUoW/7VY2u8H3nSJobOx
O4lC2zIvwmpOtlLdDyLYtieBKvyHjeP5P94nc0RIX5mq7XBcBDRD2ofKK2yc
d1HTcKsRIaUvMnrcXgTX5fLjOizZuD37rEZ0lgitrVMTC61EkGgWdvSgPBsz
kxklwVYitAxKCFDfKoIIM7dCRccOpJfvyLWZJHCAeSs4bbkIThXu56QXt6N0
5kiDeyaB5ne1WXwhAQf+bBSarm3H4F1Fc3nHCPw+LSxleTcBf0x1Ga8IaMMt
Hv07v54XooXEN+5LLQHLM49HGtS1olRinDLuI0THOGdKdBoBTo+93CeaWzDi
85OpsLpJ1JsTTaRcJkDQXHp92yILlbLWPqPrTWJOQGy7owsBu+sCsuI13uBM
mElwetIE0p44n+7ZR8C0v+HIqa8a8OSUx9dqwnE8F/rS0W0TAW/EFwpuKtTj
787xfnzBGM4ECWtGpUIICRzMULarQo3IyrPlfAGGqodoXewXQp7sscVJJRru
vHCTvoU7iuElp1ucW4UQteZeoL3XXeQrRPgUD45g3Ik4b6N2IchfUyRdoDwC
a954jZTDx1h5vaqUISFsd/fLFv/BgPo3+w5E9vHwEuWD/bJFIRhsUnpOldQC
l0cfYXZycQevPpBsSMAPxnkZasONsLHq6eVD74Zx+NcHzrV+BOgyVa+q676D
xt1fMX5qGELj5Ph2j2cEvNAj95/z6IBHr3tU/h0fxIWMDcrEHAE89b547q0u
2BcyMNmnPIhpcOb41hMiePJolZ5XXy9YnDM9VuU5gCbfBj4klYmAWMYq22jK
AWrT9Oepu+9RvmnA+YmqGH6/rzzl7zQItF2t2sxXfVjhZx1c5iyGb5ihP1d/
GQLq+gqHBede3CuStTYkiOH78DHWBUcu/DlbsuYsuxvV3o15RFeLweKfIXnb
ZB4Yl5LbfzvZhZuqnlZmzoihanX/StcSPjBi9vgefsfGnEC7V22mEih/cHSl
FX0E1jCm6fttO7DLKSIn+6oEtIbrjWypo/DLzQ+XDpS2oYbdWqZ/jQSczRYi
dqwTwO0b0TM5wa2YFFgQ/vyjBByKPccYtgJYLE3+4xvbFrx4meNpbiSFXtKW
ICtzAdgXrGm1zGfh0xKV8GPnpUD8xyRq1fAosLM9zl9ReIMPucNU03Qp3KGy
w2gHRsFgverhze4NWCcnf2NPsxRWKykQ3fojsE+JEZuYU48Ritd32SxI4Zpq
9N9bGTzQVUx5QxLUordWctgtQxkU1+Z2kjqHYeM0yb/GrQaT/w5OU3aSwU73
8wF2C4PgrbhGv7K5AmlZLFFfoAw2etdnDtdzoNSSZmFhw8DvuGuHo67LQN1M
1Dm9uhdOGLPM7/iWYI9JKjkqXQYzDvKz1zgdcG0o9uQKszy0HnvxPLJABgtn
yy6a/fUWHpkUBVJVMrA2b9nL7QwZxNAWut4t1sIGi21+hx/E4MU3/c1HK2Xg
+j106mz8C4RfhT/USUmEZaqvDFsqZHB/KqO/za4I3UiqK7JIWSB4Ij3NeCYD
/rGklxtW1ONfA4lCWkM+6AwcVNDMl8Fu+2Xj4qwWfGW1WPGRQoOAkSafAw9k
cMx6NMShjY2LGrLVq1eVwUrq8lT3OBno6/tF2kl7MeGO6y3K75WQRzrSx70o
A0lh8x3mwwH8paOk3HLTCzAe/Kjs6rD0Z1JP1fTCEIbyTOgm39ZBXcAFgeZO
GSzjO1bq7eei0QneJd2EehizM3RrWJSC1hHXsPVMHvLMJpqSKl7D1sJzn/q7
pTCzd53P5lk+Pj6uaaM/1gj+m3MpH4ql8Dqt39NBOoKbDjqGNKg1AWfq9CHX
eCmE0Lj+agWjeOo94X3I8i38mOGokXdKCh5UTwPt7QKsVtZMjzjdApbnc6Nc
dkshtjRT+MxXgMWsVgrJqhV6wllxtM8SoOSSWffCBPiJ2b6N4tAGH6cV/bY3
S4Bsbn0z47gAzT2d07Rc20HuuF+C7JEE4n/rdPpVSYB0+5zIuqsdYPIzefFM
iARUfGiHL98bxZvR2xibHrPhxZzVK6mlBJh6s+4xn0ZQR1mJvK++E2yedt4V
K0mgIn48JeHQCMYa6U7qc7vA7qB8zB2OGN5+WD6b9CMfW5UoWzbL9YC2Ez1v
niaGuw1/jjb/ysOrspgEA61eCPWy7PS8IYYn1z0U2rK4GCH3uiri6z7QMX+2
iukthoe4wtIndxj3fDSeDGH0Q1uYG57cLQavj/XkQzCEEZftzXPIHHjKZK+3
I0TAGDxTuiv/A15xVdWILBqA1/K7GB6pIkhjkSjzLe9xTuH2On3VQbDfyzLv
sRHB3rZR5UvzvRha7KPo0DQIiX7pI3/PEkAxPfLTbdNuPBceNMOiDsHzDrJ7
fgUBcwNCHIpjI3Zli/imw+BfRPqSGUtAQ7VN9M/9bVhEYUh6NLlg8H7yMfkI
AWsXxoL2OzUj/VDNeZPPXEjMOxIUs4EAPW03ufCtjRj0ZbrpRC8PZDt8FzcI
hZBG/zy9aFCHCxz2LwnP+UBQvuQnLrnAKaK2lveXY1NVhljt/ggoruSrh70U
wpmUwuA7Wfm4W2h75WT4KEStpa6+XC0Er5WkqrPXwpd8Un6d4iKAeU33vUa1
QnDZ0xw1a5UD0fW9t2PDx8DYV17HvkMITv63v9NcXw4zmvayqw/GoelajM67
KSGYmvZu/kSuA+MNNuoq1RPg4b95bJU+AZ2EVqr/ukYwc6561cidhImpgrS9
S758gV37HdPfQtJzLQ1DFQLK7t3ODVvyhepV+vQErxWMTk0UlFou+XFeUWNo
jQhspd4Hy452QAJJVrjDUAyt9+ac//UTQW6y4VaX7zoh5bPQVpcphpLa6FR7
lgjGtBuyNTd2w38BHJ7LLA==
        "]}, {Automatic}],
      Editable->False,
      SelectWithContents->True,
      Selectable->False]}], ",", 
    RowBox[{"v", "\[Rule]", 
     InterpretationBox[
      RowBox[{
       TagBox["InterpolatingFunction",
        "SummaryHead"], "[", 
       DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = 
        "Ready"}, 
        TemplateBox[{
          PaneSelectorBox[{False -> GridBox[{{
                PaneBox[
                 ButtonBox[
                  DynamicBox[
                   FEPrivate`FrontEndResource[
                   "FEBitmaps", "SquarePlusIconMedium"]], 
                  ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], 
                 Alignment -> {Center, Center}, ImageSize -> 
                 Dynamic[{
                   Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                GraphicsBox[{{{{}, {}, 
                    TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAotpLlPIyYj4AoFhQuOw8PsYpATtp
saA/kzRwsleIej91Da0CI2WxP2IeZPBBp4s/apta4A/YuT/u8tBKOIyUP96v
D5ZHEME/nSAnL2wkmz8vzpNoZI7FP7vLSSy7JqE/MndYd8C/yT9nSPwV7H6k
P13cvrL5Ss4//SdPgJkfqD9bbpgSfmDRP869b0Llr6s/4bPx6R510z8nr2un
/AKvP3vXm1euttU/moXgOK9OsT9uQGZj3dHXP77Wo+6X/LI/+Ha2CnHi2T9c
y+6K86C0P5eLV0jzH9w/5IFHgRhntj+O5RgkFTfeP+RLYvgpDLg/zY4Vy5I9
4D+HSW0pb9C5P56R4VFNWuE/f6d9962Guz8ct72n12PiPwpKZfOIGL0/pEvC
SNmD4z8OqakNmMK+P9gC17iqkOQ/4JSO8DoiwD8WKRR087PlP9uHyFwS68A/
IDYUfe7R5j/WIzAlx6XBP9dlJFW53Oc/yrzPe1FIwj+YBF14+/3oP3Kgawv8
6MI/Bcalag0M6j+GJ8U7bG3DPz5usarRFOs/x4LnFdXbwz+BheU1DTTsP9b0
6w6HOsQ/cL8pkBhA7T82F/dLd3jEP2loljWbYu4/DahzrSqcxD8u+MUo0H/v
PwRQHiPKncQ/T9WCdepE8D8D49d5H4HEPwzmNnwo1fA/Ukj+Vw1CxD8fCHNq
zlvxP1NsyJYM68M/mJ2Qf83f8T8Z7g3P4H3DP5ZqQjoIb/I/FYtb0uPvwj/q
SHzcqvTyPy4gnoZ2WMI/xF5KJImF8z+wLH5FCqPBP/SFoFPPDPQ/4Pk3X0bs
wD+KINipbpH0P6ZYlO7tLsA/pfKjpUkh9T/YBS3v2bC+PxbW94iMp/U/g2j9
+eISvT8M8d8RCzn2P8bkQurNRrs/aH+pweLH9j+nJjg3NXq5Pxof+1giTfc/
B1vU/o/Gtz9R9uCVnd33PzdzELtf6bU/3t5OuoBk+D9P4n67mii0P9E6ngW9
6Pg/Y1G0gIZusj9JzoH2NHj5Pxg0HVdRjbA/F3PtzhT++T8Or65my5atP2pP
7Uwwj/o/CbJDO37GqT8jn87xpB37P7uVka7HB6Y/MgA4foGi+z8qdn5f14mi
P8aYNbCZMvw/rFUyr6iBnT+xQrvJGbn8P1KHdXXacZY/ISTViNVK/T8EL7DG
rJiNP/Z40G7q2f0/uUxOz+ctfT8i31M8Z1/+PxANwZet/DI/03xrrx/w/j8P
Q/WcWil9v9orCwpAd/8/EsywiQTBjL+2hub2////P0Hj1dXTjZW/vqXsIQ==

                    "]]}, 
                    Annotation[#, "Charting`Private`Tag$3102#1"]& ]}}, {}}, {
                 DisplayFunction -> Identity, Ticks -> {Automatic, Automatic},
                   AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                  GridLines -> {None, None}, DisplayFunction -> Identity, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                  All, DisplayFunction -> Identity, AspectRatio -> 1, 
                  Axes -> {False, False}, AxesLabel -> {None, None}, 
                  AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                  Frame -> {{True, True}, {True, True}}, 
                  FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                  Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                  FrameTicks -> {{None, None}, {None, None}}, 
                  GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                  Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                  Method -> {
                   "DefaultBoundaryStyle" -> Automatic, 
                    "DefaultGraphicsInteraction" -> {
                    "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None, 
                    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                  PlotRange -> {{0., 2.}, {-0.021048841406329236`, 
                   0.16106535639539754`}}, PlotRangeClipping -> True, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                GridBox[{{
                   RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {
                  "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                 BaseStyle -> {
                  ShowStringCharacters -> False, NumberMarks -> False, 
                   PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
              GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              BaselinePosition -> {1, 1}], True -> GridBox[{{
                PaneBox[
                 ButtonBox[
                  DynamicBox[
                   FEPrivate`FrontEndResource[
                   "FEBitmaps", "SquareMinusIconMedium"]], 
                  ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], 
                 Alignment -> {Center, Center}, ImageSize -> 
                 Dynamic[{
                   Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                GraphicsBox[{{{{}, {}, 
                    TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAotpLlPIyYj4AoFhQuOw8PsYpATtp
saA/kzRwsleIej91Da0CI2WxP2IeZPBBp4s/apta4A/YuT/u8tBKOIyUP96v
D5ZHEME/nSAnL2wkmz8vzpNoZI7FP7vLSSy7JqE/MndYd8C/yT9nSPwV7H6k
P13cvrL5Ss4//SdPgJkfqD9bbpgSfmDRP869b0Llr6s/4bPx6R510z8nr2un
/AKvP3vXm1euttU/moXgOK9OsT9uQGZj3dHXP77Wo+6X/LI/+Ha2CnHi2T9c
y+6K86C0P5eLV0jzH9w/5IFHgRhntj+O5RgkFTfeP+RLYvgpDLg/zY4Vy5I9
4D+HSW0pb9C5P56R4VFNWuE/f6d9962Guz8ct72n12PiPwpKZfOIGL0/pEvC
SNmD4z8OqakNmMK+P9gC17iqkOQ/4JSO8DoiwD8WKRR087PlP9uHyFwS68A/
IDYUfe7R5j/WIzAlx6XBP9dlJFW53Oc/yrzPe1FIwj+YBF14+/3oP3Kgawv8
6MI/Bcalag0M6j+GJ8U7bG3DPz5usarRFOs/x4LnFdXbwz+BheU1DTTsP9b0
6w6HOsQ/cL8pkBhA7T82F/dLd3jEP2loljWbYu4/DahzrSqcxD8u+MUo0H/v
PwRQHiPKncQ/T9WCdepE8D8D49d5H4HEPwzmNnwo1fA/Ukj+Vw1CxD8fCHNq
zlvxP1NsyJYM68M/mJ2Qf83f8T8Z7g3P4H3DP5ZqQjoIb/I/FYtb0uPvwj/q
SHzcqvTyPy4gnoZ2WMI/xF5KJImF8z+wLH5FCqPBP/SFoFPPDPQ/4Pk3X0bs
wD+KINipbpH0P6ZYlO7tLsA/pfKjpUkh9T/YBS3v2bC+PxbW94iMp/U/g2j9
+eISvT8M8d8RCzn2P8bkQurNRrs/aH+pweLH9j+nJjg3NXq5Pxof+1giTfc/
B1vU/o/Gtz9R9uCVnd33PzdzELtf6bU/3t5OuoBk+D9P4n67mii0P9E6ngW9
6Pg/Y1G0gIZusj9JzoH2NHj5Pxg0HVdRjbA/F3PtzhT++T8Or65my5atP2pP
7Uwwj/o/CbJDO37GqT8jn87xpB37P7uVka7HB6Y/MgA4foGi+z8qdn5f14mi
P8aYNbCZMvw/rFUyr6iBnT+xQrvJGbn8P1KHdXXacZY/ISTViNVK/T8EL7DG
rJiNP/Z40G7q2f0/uUxOz+ctfT8i31M8Z1/+PxANwZet/DI/03xrrx/w/j8P
Q/WcWil9v9orCwpAd/8/EsywiQTBjL+2hub2////P0Hj1dXTjZW/vqXsIQ==

                    "]]}, 
                    Annotation[#, "Charting`Private`Tag$3102#1"]& ]}}, {}}, {
                 DisplayFunction -> Identity, Ticks -> {Automatic, Automatic},
                   AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                  GridLines -> {None, None}, DisplayFunction -> Identity, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                  All, DisplayFunction -> Identity, AspectRatio -> 1, 
                  Axes -> {False, False}, AxesLabel -> {None, None}, 
                  AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                  Frame -> {{True, True}, {True, True}}, 
                  FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                  Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                  FrameTicks -> {{None, None}, {None, None}}, 
                  GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                  Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                  Method -> {
                   "DefaultBoundaryStyle" -> Automatic, 
                    "DefaultGraphicsInteraction" -> {
                    "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                    "Effects" -> {
                    "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None, 
                    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                  PlotRange -> {{0., 2.}, {-0.021048841406329236`, 
                   0.16106535639539754`}}, PlotRangeClipping -> True, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                GridBox[{{
                   RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {
                  "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                 BaseStyle -> {
                  ShowStringCharacters -> False, NumberMarks -> False, 
                   PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
              GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              BaselinePosition -> {1, 1}]}, 
           Dynamic[Typeset`open$$], ImageSize -> Automatic]},
         "SummaryPanel"],
        DynamicModuleValues:>{}], "]"}],
      InterpolatingFunction[{{0., 2.}}, {
       5, 7, 2, {96}, {4}, 0, 0, 0, 0, Automatic, {}, {}, 
        False}, CompressedData["
1:eJxFkosv1AEAxw85dJlJTi2UIb1o5LVVvimuNUvS1EWmkvTyuE5SLrnWyu1G
rYhbqp1XlHQVdSqFsF7yOJFCnqfOvbjzO+cOtdXWZ/vs8w98HA4lhMYYkkgk
gz8eIP3Hz9xQvYLrgr/1AbvFSni1gQGbN8x0b1M24m/2Ojm7ccDKjZgmUXgg
PhrXcyv4cPvUS87tKkHsp6qgAlI5QsS0d53ZAmSI7c0Ha6pQKyZ2ycQvwGLG
BulNapHHFMnY+fWoZOKaiXsjAqq0bbcvv0cH8dTKs6cZHrbPV48sboN2Y3aQ
YKsIdZGMk6nxX8BJC86k8boQcndNhWVDNxbXmrb0yL+jv39EcW9JH0rFD3bn
DPyALyGMqOvox1LtLXOhcABzurQ3FfmDGJo9yChOH8LrM+dPffUeBk+Zx6TI
hsE8VpnkVziC4MGW04x9YqyKGEsushjFvA5ySlfjKJa/jCrxpf/EhgJhB0/y
E3s5lkY61i8wE4+777eQIGvv26gavgT3/Wyz7D3H0Oh8+tWFpjH8yI1sMvaT
QmtGa+VWSbGQ5fbN0lWGtXLqcG6RDIEH5mR2tnJEtY9qCm/IcTag1WA1RYHr
z4QUwUUFylfyrb2nFYhubrDo81UikVy9iJ+kBAsPlxwWKMFJ4du7SJW4+TjH
UeIyjkIJZ+XD6HEIHNNcE++O49X+Ux7rv4/jfc4RH4I6gc7P4RurQycwZLLT
n5U1AeXmrTR8mID+rE+QIVkFs6drQhr9VaBKl4VlnFehL4pdfqZOhWLRoFGs
sRpx2wIi9mxXw/Nl8ZPATDX0bibzvdrUeFtw9KCT9SS41A9Cq32TqIxs3R4o
nERvUee3ZBsCZGnPidJkAuvWD+m7vxCgn/uVSfHSgF2nsN+UrUGZKfEoXqVB
qs64nXF8Cjvk1uqkgSksG3CmptC1UIq8fFNbtKhvCgxPo00juzqMxa6ZRkx5
zJ1LnjpceS4i2lt1KKv33+kQp8fH5kf3EsxmIPtqR3pdPAOLYS59wZZZuCu0
gvC+WfA0LLprwhz+bb/5N3Wzh2Y=
       "], {
       Developer`PackedArrayForm, CompressedData["
1:eJwl0I1GgwEAQNGvUpZSmqUspRERESNGjDFGjM0YEf0QkUZERERExBgRERER
ERERERERERERERExYkQdupwXuLGZUn6xLgiC6eC/BppoppV2wnTSTQ99xBhg
kCGGGSHOKAnGSJIiTYZxsuQoUGSCSaaYZY55FiixxDIrrLLGOhtsssU2ZSrs
sMse+xxwyBHHnHDKGedccMkV19xwyx33PPDIE8+88Mob73zwyRdVvqnxwy/1
BjcSooU2OojQRZRe+vkDD8gtsA==
        "], CompressedData["
1:eJw1k3k0FYgXx6WShFJhFC2aRvUq66SNW8lYKlOERHKsEY/MS1lDmPSkJ0ti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        "]}, {Automatic}],
      Editable->False,
      SelectWithContents->True,
      Selectable->False]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.796877271738429*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"9f186e3c-845d-4469-8b15-a28e43ed7d82"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw11gk0Vd3bAHBDITJEpeRV5kRKmYuHpDRdmnSRN0MZS6TJrAxJyDWTXISM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       "]]},
     Annotation[#, "Charting`Private`Tag$3155#1"]& ]}, {}},
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None},
  PlotRange->{{-1., 1.0454418842852273`}, {-0.021048848526266407`, 
   0.16116978116594638`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.7968772719411983`*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"6ea431df-8b69-4b96-9111-d4e87065d081"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Geod", "[", 
     RowBox[{"ir_", ",", "iphi_", ",", " ", 
      RowBox[{"tt_", ":", "3"}]}], "]"}], " ", ":=", " ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "s", "}"}], ",", " ", 
      RowBox[{
       RowBox[{"s", "=", 
        RowBox[{"NDSolve", "[", 
         RowBox[{
          RowBox[{"Evaluate", "[", 
           RowBox[{"Equv", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"r", "\[Rule]", "ir"}], ",", 
              RowBox[{"phi", "\[Rule]", "iphi"}]}], "}"}]}], "]"}], ",", " ", 
          
          RowBox[{"{", 
           RowBox[{"u", ",", "v"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "tt"}], "}"}]}], "]"}]}], ";", " ", 
       RowBox[{"Show", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Plot3D", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"F", "[", 
              RowBox[{"x", ",", "y"}], "]"}], "/.", 
             RowBox[{"{", 
              RowBox[{"r", "\[Rule]", "ir"}], "}"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
            RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", " ", 
          RowBox[{"ParametricPlot3D", "[", 
           RowBox[{
            RowBox[{"Evaluate", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"u", "[", "t", "]"}], ",", 
                 RowBox[{"v", "[", "t", "]"}], ",", 
                 RowBox[{"F", "[", 
                  RowBox[{
                   RowBox[{"u", "[", "t", "]"}], ",", 
                   RowBox[{"v", "[", "t", "]"}]}], "]"}]}], "}"}], "/.", 
               RowBox[{"{", 
                RowBox[{"r", "\[Rule]", "ir"}], "}"}]}], "/.", "s"}], "]"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "0", ",", "tt"}], "}"}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}]}], "}"}], 
        "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7968772244483967`*^9, 3.796877228690296*^9}, {
  3.796877311186413*^9, 3.796877318204956*^9}, {3.796877556122757*^9, 
  3.7968776484379377`*^9}, {3.796877746370331*^9, 3.7968777516422787`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"7005c3d2-8336-4298-a662-73f28dfc54ec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Geod", "[", 
    RowBox[{
     RowBox[{"1", "/", "hh"}], ",", "pp", ",", " ", "tt"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"hh", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pp", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"tt", ",", "3", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.796877319963458*^9, 3.7968773200348787`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"b068366f-9c94-4ebe-9f64-5f619cb3f8d5"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`hh$$ = 
    1.65, $CellContext`pp$$ = -0.395, $CellContext`tt$$ = 5., Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`hh$$], 1, 10}, {{
       Hold[$CellContext`pp$$], 0}, -1, 1}, {
      Hold[$CellContext`tt$$], 3, 10}}, Typeset`size$$ = {360., {173., 178.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`hh$$ = 1, $CellContext`pp$$ = 
        0, $CellContext`tt$$ = 3}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> $CellContext`Geod[
       1/$CellContext`hh$$, $CellContext`pp$$, $CellContext`tt$$], 
      "Specifications" :> {{$CellContext`hh$$, 1, 
         10}, {{$CellContext`pp$$, 0}, -1, 1}, {$CellContext`tt$$, 3, 10}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{405., {246., 252.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.7968776761040487`*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"11ec1e91-c635-475e-be30-43e9f4dec449"]
}, Open  ]]
},
WindowSize->{808, 692},
WindowMargins->{{242, Automatic}, {Automatic, 12}},
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (March 13, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e9047a57-177b-49b0-b6a2-34916fbb1169"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 496, 16, 30, "Input",ExpressionUUID->"aedf0dac-bf10-4a2d-90f5-6cf8f19207c0"],
Cell[CellGroupData[{
Cell[1079, 40, 303, 9, 30, "Input",ExpressionUUID->"d815061c-1a03-45ac-ba1d-325599419cd1"],
Cell[1385, 51, 523, 15, 69, "Output",ExpressionUUID->"fa5f56bc-f2e0-4178-9d73-d4b529c8c3f6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1945, 71, 303, 9, 30, "Input",ExpressionUUID->"8581354c-cfbc-40e9-a80b-c385f77db855"],
Cell[2251, 82, 525, 15, 69, "Output",ExpressionUUID->"edd96b72-ccf4-4120-8a59-d8a7d77a1691"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2813, 102, 373, 8, 73, "Input",ExpressionUUID->"44706242-52dc-49b6-9d9d-3fc859304f6a"],
Cell[3189, 112, 540, 16, 73, "Output",ExpressionUUID->"4aa5729e-da04-4e40-9cda-ace83220c6df"],
Cell[3732, 130, 490, 14, 73, "Output",ExpressionUUID->"1db6028c-b0e6-4548-b1c0-b04e47358ea6"],
Cell[4225, 146, 540, 16, 73, "Output",ExpressionUUID->"0814b7dd-bac5-4521-8d4b-aa6ade94f817"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4802, 167, 471, 12, 52, "Input",ExpressionUUID->"96717c7e-2234-46a6-9e4d-c66a62680b2d"],
Cell[5276, 181, 1967, 60, 73, "Output",ExpressionUUID->"515c19b6-b97c-4a2f-a3a2-8295bd0a95f0"],
Cell[7246, 243, 3393, 107, 196, "Output",ExpressionUUID->"4e06ab3f-efc1-4823-ae2d-0bf33e80d7ed"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10676, 355, 174, 4, 30, "Input",ExpressionUUID->"bec40bbd-c0d3-4da5-a1e5-58a4f7def6d5"],
Cell[10853, 361, 193, 4, 34, "Output",ExpressionUUID->"d2e6eed4-235d-4897-b8d8-69a358723c5d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11083, 370, 2192, 68, 115, "Input",ExpressionUUID->"ac529ce2-424a-42de-9319-7a520e3d2719"],
Cell[13278, 440, 6876, 200, 274, "Output",ExpressionUUID->"c06f9972-8a19-4680-94d1-263c92b985f7"],
Cell[20157, 642, 8960, 255, 388, "Output",ExpressionUUID->"9d6c00d7-8052-407e-9b53-aded4f3c0d7d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29154, 902, 2127, 64, 73, "Input",ExpressionUUID->"4c3f8c37-603a-4018-ac1b-10132a59863d"],
Cell[31284, 968, 5096, 145, 231, "Output",ExpressionUUID->"14403f97-4b02-4341-82ae-d1531f0e4e19"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36417, 1118, 940, 27, 73, "Input",ExpressionUUID->"cd8b0d42-90a3-4b24-8992-85ae886747d0"],
Cell[37360, 1147, 36984, 701, 116, "Output",ExpressionUUID->"9f186e3c-845d-4469-8b15-a28e43ed7d82"],
Cell[74347, 1850, 6466, 120, 64, "Output",ExpressionUUID->"6ea431df-8b69-4b96-9111-d4e87065d081"]
}, Open  ]],
Cell[80828, 1973, 2631, 67, 136, "Input",ExpressionUUID->"7005c3d2-8336-4298-a662-73f28dfc54ec"],
Cell[CellGroupData[{
Cell[83484, 2044, 610, 16, 30, "Input",ExpressionUUID->"b068366f-9c94-4ebe-9f64-5f619cb3f8d5"],
Cell[84097, 2062, 1888, 38, 517, "Output",ExpressionUUID->"11ec1e91-c635-475e-be30-43e9f4dec449"]
}, Open  ]]
}
]
*)

